/**
 * Composition Profiler (p-value calculations) 
 * 
 * Vladimir Vacic, University of California, Riverside
 * Vladimir N. Uversky, Indiana University School of Medicine, Indianapolis 
 * A. Keith Dunker, Indiana University School of Medicine, Indianapolis
 * Stefano Lonardi, University of California, Riverside
 *
 * Sep-20-2006
 */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

extern "C"  {
    double incbet(double, double, double);
}

/** Estimates  p-value using the two sample t-test */
double ttest(int k1, int n1, int k2, int n2)  {
    double mean1, mean2;
    double var1_mult, var2_mult;
    double svar, df, t;

    mean1 = 1.0 * k1 / n1;
    mean2 = 1.0 * k2 / n2;

    var1_mult = 1.0*k1*(1-mean1)*(1-mean1) + (n1-k1)*mean1*mean1;
    var2_mult = 1.0*k2*(1-mean2)*(1-mean2) + (n2-k2)*mean2*mean2;

    df   = n1 + n2 - 2;
    svar = (var1_mult + var2_mult) / df;
    t    = (mean1-mean2) / sqrt(svar*(1.0/n1 + 1.0/n2));

    return incbet(0.5*df, 0.5, df/(df+t*t));
}


int main(int argc, char** argv)  {
    int sample_pos, sample_total;
    int back_pos,   back_total;

    if (argc!=5)  {
        printf("Usage: %s sample_pos_# sample_total_# background_pos_# background_total_#\n", argv[0]);
        exit(1);
    }

    sample_pos   = atoi(argv[1]);
    sample_total = atoi(argv[2]);
    back_pos     = atoi(argv[3]);
    back_total   = atoi(argv[4]);

    printf("%f\n", ttest(sample_pos, sample_total, back_pos, back_total));

    exit(0);
}

