# ColorScheme.rb - Miscelaneous amino acid coloring schemes. 
#
# Vladimir Vacic, University of California, Riverside
# Vladimir N. Uversky, Indiana University School of Medicine, Indianapolis
# A. Keith Dunker, Indiana University School of Medicine, Indianapolis
# Stefano Lonardi, University of California, Riverside
#
# Oct-21-2006


module ColorScheme 

    COLOR_SCHEME = {
    'weblogo' => {
        'G' => '0 0.8 0', 
        'S' => '0 0.8 0',
        'T' => '0 0.8 0',
        'Y' => '0 0.8 0',
        'C' => '0 0.8 0',
        'N' => '0.8 0 0.8', 
        'Q' => '0.8 0 0.8',
        'K' => '0 0 0.8', 
        'R' => '0 0 0.8',
        'H' => '0 0 0.8',
        'D' => '0.8 0 0',
        'E' => '0.8 0 0',
        'P' => '0.5 0.5 0.5',
        'A' => '0.5 0.5 0.5',
        'W' => '0.5 0.5 0.5',
        'F' => '0.5 0.5 0.5',
        'L' => '0.5 0.5 0.5',
        'I' => '0.5 0.5 0.5',
        'M' => '0.5 0.5 0.5',
        'V' => '0.5 0.5 0.5'
    },
    'amino' => {
        'G' => '0.9 0.9 0.9', 
        'S' => '0.98 0.59 0',
        'T' => '0.98 0.59 0',
        'Y' => '0.2 0.2 0.67', 
        'C' => '0.9 0.9 0',
        'N' => '0 0.86 0.86', 
        'Q' => '0 0.86 0.86',
        'K' => '0.08 0.35 1',
        'R' => '0.08 0.35 1',
        'H' => '0.51 0.51 0.82', 
        'D' => '0.9 0.04 0.04',
        'E' => '0.9 0.04 0.04',
        'P' => '0.86 0.59 0.71', 
        'A' => '0.78 0.78 0.78', 
        'W' => '0.71 0.35 0.71',  
        'F' => '0.2 0.2 0.67',
        'L' => '0.06 0.51 0.06', 
        'I' => '0.06 0.51 0.06',
        'M' => '0.9 0.9 0',
        'V' => '0.06 0.51 0.06'
    },
    'shapley' => {
       'G' => '0.9 0.9 0.9',
       'S' => '1 0.3 0.3',
       'T' => '0.63 0 0.25',
       'Y' => '0.72 0.63 0.26',
       'C' => '1 1 0.44',
       'N' => '1 0.49 0.44',
       'Q' => '1 0.3 0.3',
       'K' => '0.28 0.28 0.72',
       'R' => '0 0 0.49',
       'H' => '0.44 0.44 1',
       'D' => '0.63 0 0.26',
       'E' => '0.4 0 0',
       'P' => '0.33 0.3 0.26',
       'A' => '0.55 1 0.55',
       'W' => '0.33 0.3 0.26',
       'F' => '0.33 0.3 0.26',
       'L' => '0.27 0.37 0.27',
       'I' => '0 0.3 0',
       'M' => '0.72 0.63 0.26',
       'V' => '0.9 0.9 0.9'
    },
    'aromatics' => {
        'G' => '0.5 0.5 0.5',
        'S' => '0.5 0.5 0.5',
        'T' => '0.5 0.5 0.5',
        'Y' => '0 0.8 0',
        'C' => '0.5 0.5 0.5',
        'N' => '0.5 0.5 0.5',
        'Q' => '0.5 0.5 0.5',
        'K' => '0.5 0.5 0.5', 
        'R' => '0.5 0.5 0.5',
        'H' => '0.5 0.5 0.5',
        'D' => '0.5 0.5 0.5', 
        'E' => '0.5 0.5 0.5',
        'P' => '0.5 0.5 0.5',
        'A' => '0.5 0.5 0.5',
        'W' => '0 0.8 0',
        'F' => '0 0.8 0',
        'L' => '0.5 0.5 0.5',
        'I' => '0.5 0.5 0.5',
        'M' => '0.5 0.5 0.5',
        'V' => '0.5 0.5 0.5'
    },
    'charge' => {
        'G' => '0.5 0.5 0.5',
        'S' => '0.5 0.5 0.5',
        'T' => '0.5 0.5 0.5',
        'Y' => '0.5 0.5 0.5',
        'C' => '0.5 0.5 0.5',
        'N' => '0.5 0.5 0.5',
        'Q' => '0.5 0.5 0.5',
        'K' => '0 0 0.8', 
        'R' => '0 0 0.8',
        'H' => '0.5 0.5 0.5',
        'D' => '0.8 0 0', 
        'E' => '0.8 0 0',
        'P' => '0.5 0.5 0.5',
        'A' => '0.5 0.5 0.5',
        'W' => '0.5 0.5 0.5',
        'F' => '0.5 0.5 0.5',
        'L' => '0.5 0.5 0.5',
        'I' => '0.5 0.5 0.5',
        'M' => '0.5 0.5 0.5',
        'V' => '0.5 0.5 0.5'
    },
    'hydro_e' => {
        'P' => '0.1 0.1 0.1',
        'Y' => '0.1 0.1 0.1',
        'C' => '0.1 0.1 0.1',
        'G' => '0.1 0.1 0.1',
        'A' => '0.1 0.1 0.1',
        'M' => '0.1 0.1 0.1',
        'W' => '0.1 0.1 0.1',
        'L' => '0.1 0.1 0.1',
        'V' => '0.1 0.1 0.1',
        'F' => '0.1 0.1 0.1',
        'I' => '0.1 0.1 0.1',
        'R' => '0 1 1',
        'K' => '0 1 1',
        'D' => '0 1 1',
        'Q' => '0 1 1',
        'N' => '0 1 1',
        'E' => '0 1 1',
        'H' => '0 1 1',
        'S' => '0 1 1',
        'T' => '0 1 1'
    },
    'hydro_kd' =>  {
        'A' => '0.1 0.1 0.1',
        'M' => '0.1 0.1 0.1',
        'C' => '0.1 0.1 0.1',
        'F' => '0.1 0.1 0.1',
        'L' => '0.1 0.1 0.1',
        'V' => '0.1 0.1 0.1',
        'I' => '0.1 0.1 0.1',
        'R' => '0 1 1',
        'K' => '0 1 1',
        'D' => '0 1 1',
        'E' => '0 1 1',
        'N' => '0 1 1',
        'Q' => '0 1 1',
        'H' => '0 1 1',
        'P' => '0 1 1',
        'Y' => '0 1 1',
        'W' => '0 1 1',
        'S' => '0 1 1',
        'T' => '0 1 1',
        'G' => '0 1 1'
    },
    'hydro_fp' =>  {
        'H' => '0.1 0.1 0.1',
        'T' => '0.1 0.1 0.1',
        'A' => '0.1 0.1 0.1',
        'P' => '0.1 0.1 0.1',
        'Y' => '0.1 0.1 0.1',
        'V' => '0.1 0.1 0.1',
        'C' => '0.1 0.1 0.1',
        'L' => '0.1 0.1 0.1',
        'F' => '0.1 0.1 0.1',
        'I' => '0.1 0.1 0.1',
        'M' => '0.1 0.1 0.1',
        'W' => '0.1 0.1 0.1',
        'R' => '0 1 1',
        'K' => '0 1 1',
        'D' => '0 1 1',
        'E' => '0 1 1',
        'N' => '0 1 1',
        'Q' => '0 1 1',
        'S' => '0 1 1',
        'G' => '0 1 1'
    },
    'surface_j' => {
       'G' => '0.5 0.5 0.5',
       'S' => '1 0.65 0',
       'T' => '1 0.65 0',
       'Y' => '1 0.65 0',
       'C' => '0.5 0.5 0.5',
       'N' => '1 0.65 0',
       'Q' => '1 0.65 0',
       'K' => '1 0.65 0',
       'R' => '1 0.65 0',
       'H' => '1 0.65 0',
       'D' => '1 0.65 0',
       'E' => '1 0.65 0',
       'P' => '1 0.65 0',
       'A' => '0.5 0.5 0.5',
       'W' => '0.5 0.5 0.5',
       'F' => '0.5 0.5 0.5',
       'L' => '0.5 0.5 0.5',
       'I' => '0.5 0.5 0.5',
       'M' => '0.5 0.5 0.5',
       'V' => '0.5 0.5 0.5'
    },
    'flex_v' => {
       'W' => '0 0.8 0',
       'C' => '0 0.8 0',
       'F' => '0 0.8 0',
       'I' => '0 0.8 0',
       'Y' => '0 0.8 0',
       'V' => '0 0.8 0',
       'L' => '0 0.8 0',
       'H' => '0 0.8 0',
       'M' => '0 0.8 0',
       'A' => '0 0.8 0',
       'T' => '0 0.8 0',
       'G' => '0.8 0 0',
       'S' => '0.8 0 0',
       'N' => '0.8 0 0',
       'Q' => '0.8 0 0',
       'K' => '0.8 0 0',
       'R' => '0.8 0 0',
       'D' => '0.8 0 0',
       'E' => '0.8 0 0',
       'P' => '0.8 0 0'
    },
    'interface_jt' => {
        'N' => '1 0 1',
        'R' => '1 0 1',
        'V' => '1 0 1',
        'L' => '1 0 1',
        'H' => '1 0 1',
        'C' => '1 0 1',
        'I' => '1 0 1',
        'M' => '1 0 1',
        'Y' => '1 0 1',
        'F' => '1 0 1',
        'W' => '1 0 1',
        'D' => '0 1 1',
        'K' => '0 1 1',
        'S' => '0 1 1',
        'P' => '0 1 1',
        'T' => '0 1 1',
        'A' => '0 1 1',
        'E' => '0 1 1',
        'Q' => '0 1 1',
        'G' => '0 1 1'
    },
    'solvation_jt' => {
        'A' => '1 0 1',
        'G' => '1 0 1',
        'S' => '1 0 1',
        'T' => '1 0 1',
        'P' => '1 0 1',
        'N' => '1 0 1',
        'R' => '1 0 1',
        'Q' => '1 0 1',
        'D' => '1 0 1',
        'E' => '1 0 1',
        'K' => '1 0 1',
        'W' => '0 1 1',
        'F' => '0 1 1',
        'I' => '0 1 1',
        'L' => '0 1 1',
        'M' => '0 1 1',
        'Y' => '0 1 1',
        'V' => '0 1 1',
        'C' => '0 1 1',
        'H' => '0 1 1'
    },
    'disorder_d' => {
        'G' => '0.8 0 0',
        'S' => '0.8 0 0',
        'T' => '0.5 0.5 0.5',
        'Y' => '0 0 0.8',
        'C' => '0 0 0.8',
        'N' => '0 0 0.8',
        'Q' => '0.8 0 0',
        'K' => '0.8 0 0',
        'R' => '0.8 0 0',
        'H' => '0.5 0.5 0.5',
        'D' => '0.5 0.5 0.5',
        'E' => '0.8 0 0',
        'P' => '0.8 0 0',
        'A' => '0.8 0 0',
        'W' => '0 0 0.8',
        'F' => '0 0 0.8',
        'L' => '0 0 0.8',
        'I' => '0 0 0.8',
        'M' => '0.5 0.5 0.5',
        'V' => '0 0 0.8'
    },
    'bulkiness_z' => {
        'G' =>  '0 0 0.8',
        'S' =>  '0 0 0.8',
        'A' =>  '0 0 0.8',
        'D' =>  '0 0 0.8',
        'N' =>  '0 0 0.8',
        'C' =>  '0 0 0.8',
        'E' =>  '0 0 0.8',
        'H' =>  '0 0 0.8',
        'R' =>  '0 0 0.8',
        'Q' =>  '0 0 0.8',
        'K' =>  '0 0 0.8',
        'T' =>  '0 0 0.8',
        'M' =>  '0 0 0.8',
        'P' =>  '0 0 0.8',
        'Y' =>  '0 0 0.8',
        'F' =>  '0 0 0.8',
        'I' =>  '0.8 0 0',
        'L' =>  '0.8 0 0',
        'V' =>  '0.8 0 0',
        'W' =>  '0.8 0 0'
    },        
    'polarity_z' => {
        'A' =>  '0 0 0.8',
        'G' =>  '0 0 0.8',
        'I' =>  '0 0 0.8',
        'L' =>  '0 0 0.8',
        'V' =>  '0 0 0.8',
        'F' =>  '0 0 0.8',
        'M' =>  '0 0 0.8',
        'C' =>  '0 0 0.8',
        'P' =>  '0 0 0.8',
        'Y' =>  '0 0 0.8',
        'T' =>  '0 0 0.8',
        'S' =>  '0 0 0.8',
        'W' =>  '0 0 0.8',
        'N' =>  '0 0 0.8',
        'Q' =>  '0 0 0.8',
        'K' =>  '0.8 0 0',
        'D' =>  '0.8 0 0',
        'E' =>  '0.8 0 0',
        'H' =>  '0.8 0 0',
        'R' =>  '0.8 0 0'
    },
    'linker_gh' => {
        'C' =>  '0 0 0.8',
        'G' =>  '0 0 0.8',
        'W' =>  '0 0 0.8',
        'D' =>  '0 0 0.8',
        'I' =>  '0 0 0.8',
        'N' =>  '0 0 0.8',
        'K' =>  '0 0 0.8',
        'S' =>  '0 0 0.8',
        'V' =>  '0 0 0.8',
        'A' =>  '0 0 0.8',
        'Y' =>  '0.8 0 0',
        'H' =>  '0.8 0 0',
        'T' =>  '0.8 0 0',
        'M' =>  '0.8 0 0',
        'Q' =>  '0.8 0 0',
        'E' =>  '0.8 0 0',
        'L' =>  '0.8 0 0',
        'F' =>  '0.8 0 0',
        'R' =>  '0.8 0 0',
        'P' =>  '0.8 0 0'
    },
    'alpha_n' => {
        'Y' =>  '0 0 0.8',
        'P' =>  '0 0 0.8',
        'G' =>  '0 0 0.8',
        'N' =>  '0 0 0.8',
        'S' =>  '0 0 0.8',
        'R' =>  '0 0 0.8',
        'T' =>  '0 0 0.8',
        'C' =>  '0 0 0.8',
        'I' =>  '0 0 0.8',
        'V' =>  '0 0 0.8',
        'D' =>  '0 0 0.8',
        'W' =>  '0 0 0.8',
        'Q' =>  '0 0 0.8',
        'L' =>  '0.8 0 0',
        'K' =>  '0.8 0 0',
        'M' =>  '0.8 0 0',
        'F' =>  '0.8 0 0',
        'A' =>  '0.8 0 0',
        'H' =>  '0.8 0 0',
        'E' =>  '0.8 0 0'
    },
    'beta_n' => {
        'E' =>  '0 0 0.8',
        'R' =>  '0 0 0.8',
        'N' =>  '0 0 0.8',
        'P' =>  '0 0 0.8',
        'S' =>  '0 0 0.8',
        'K' =>  '0 0 0.8',
        'H' =>  '0 0 0.8',
        'D' =>  '0 0 0.8',
        'G' =>  '0 0 0.8',
        'A' =>  '0 0 0.8',
        'Y' =>  '0.8 0 0',
        'C' =>  '0.8 0 0',
        'W' =>  '0.8 0 0',
        'Q' =>  '0.8 0 0',
        'T' =>  '0.8 0 0',
        'L' =>  '0.8 0 0',
        'M' =>  '0.8 0 0',
        'F' =>  '0.8 0 0',
        'V' =>  '0.8 0 0',
        'I' =>  '0.8 0 0'
    },
    'coil_n' => {
        'F' =>  '0 0 0.8',
        'M' =>  '0 0 0.8',
        'L' =>  '0 0 0.8',
        'A' =>  '0 0 0.8',
        'E' =>  '0 0 0.8',
        'H' =>  '0 0 0.8',
        'I' =>  '0 0 0.8',
        'Q' =>  '0 0 0.8',
        'V' =>  '0 0 0.8',
        'K' =>  '0 0 0.8',
        'W' =>  '0 0 0.8',
        'C' =>  '0.8 0 0', 
        'T' =>  '0.8 0 0',
        'D' =>  '0.8 0 0',
        'R' =>  '0.8 0 0',
        'S' =>  '0.8 0 0',
        'G' =>  '0.8 0 0',
        'Y' =>  '0.8 0 0',
        'N' =>  '0.8 0 0',
        'P' =>  '0.8 0 0'
    },
    'size_d' => {
        'G' =>  '0 0 0.8',
        'A' =>  '0 0 0.8',
        'D' =>  '0 0 0.8',
        'C' =>  '0 0 0.8',
        'S' =>  '0 0 0.8',
        'N' =>  '0.8 0 0',
        'E' =>  '0.8 0 0',
        'T' =>  '0.8 0 0',
        'V' =>  '0.8 0 0',
        'I' =>  '0.8 0 0',
        'L' =>  '0.8 0 0',
        'P' =>  '0.8 0 0',
        'Q' =>  '0.8 0 0',
        'H' =>  '0.8 0 0',
        'M' =>  '0.8 0 0',
        'F' =>  '0.8 0 0',
        'K' =>  '0.8 0 0',
        'W' =>  '0.8 0 0',
        'Y' =>  '0.8 0 0',
        'R' =>  '0.8 0 0'
    }
}
end
