# Read/write data in Fasta format.
#
# Vladimir Vacic (vladimir@cs.ucr.edu)
# Algorithms and Computational Biology Lab
# Computer Science Department
# University of California, Riverside
#
# Nov-1-2005


class Sequence
    attr_accessor :header, :sequence

    def initialize(header, sequence)
        @header = header
        @sequence = sequence
    end
end


class Fasta
    #
    # Reads a FASTA file and returns an array of Sequences.
    #
    def Fasta.read(filename)
        return Fasta.read_stream(File.open(filename, "r"))
    end

    def Fasta.read_stream(fin)
        temp = Array.new

        fin.each_line do |line|
            next if line =~ /^$/

            if line =~ /^>/
                temp << Sequence.new(line[1...line.length].strip, "")
            else
                temp.last.sequence << line.strip if (temp.length>0)
            end
        end

        return temp
    end

    #
    # Writes a file in FASTA format.
    #
    def Fasta.write(seqs, filename)
        fout = File.open(filename, "w")

        seqs.each do |seq|
            fout << ">#{seq.header}\n"

            if seq.sequence.length <= 80
                fout << "#{seq.sequence}\n\n"
            else
                i = 0
                while i <= seq.sequence.length
                    upper = i+80 <= seq.sequence.length ? i+80 : seq.sequence.length
                    fout << "#{seq.sequence[i...upper]}\n"            
                    i += 80
                end
                fout << "\n"
            end
        end     

        fout.close
    end
end
