#!/usr/bin/env ruby
#
# CGI interface to the Composition Profiler classes.
#
# Vladimir Vacic, University of California, Riverside
# Predrag Radivojac, Indiana University, Bloomington
# A. Keith Dunker, Indiana University School of Medicine, Indianapolis
# Stefano Lonardi, University of California, Riverside
#
# Aug-21-2006


require "cgi"
require "./AminoAcid.rb"
require "./DrawChart.rb"
require "./Fasta.rb"


PATH = "../"
temp = "/data/www/cprofiler/cache/"
datasets = "/data/www/cprofiler/datasets/"

cgi = CGI.new("html3")

command = ""
command = cgi["command"].read if cgi.has_key?("command")

submit = ""
submit = cgi["submit"].read if cgi.has_key?("submit")

query_sample = ""
query_sample = cgi["query_sample"].read if cgi.has_key?("query_sample")

query_file = ""
query_file = cgi["query_file"].read if cgi.has_key?("query_file")

query_source = "B"
query_source = cgi["query_source"].read if cgi.has_key?("query_source")

query_distrib = "sprot"
query_distrib = cgi["query_distrib"].read if cgi.has_key?("query_distrib")

back_sample = ""
back_sample = cgi["back_sample"].read if cgi.has_key?("back_sample")

back_file = ""
back_file = cgi["back_file"].read if cgi.has_key?("back_file")

back_source = "B"
back_source = cgi["back_source"].read if cgi.has_key?("back_source")

back_distrib = "sprot"
back_distrib = cgi["back_distrib"].read if cgi.has_key?("back_distrib")

alpha_value = 0.05
alpha_value = cgi["alpha_value"].read.to_f if cgi.has_key?("alpha_value")

bonferroni = false 
bonferroni = cgi["bonferroni"].read=="on" if cgi.has_key?("bonferroni") 

iterations = 10000
iterations = cgi["iterations"].read.to_f if cgi.has_key?("iterations")

order = "alpha"
order = cgi["order"].read if cgi.has_key?("order")

color = "bw"
color = cgi["color"].read if cgi.has_key?("color")

yaxis = ""
yaxis = cgi["yaxis"].read if cgi.has_key?("yaxis")

format = "PNG"
format = cgi["format"].read if cgi.has_key?("format")

chart_height = "3.5" 
chart_height = cgi["chart_height"].read if cgi.has_key?("chart_height")

chart_width = "5"
chart_width = cgi["chart_width"].read if cgi.has_key?("chart_width")

chart_units = "inches"
chart_units = cgi["chart_units"].read if cgi.has_key?("chart_units")

antialias = false
antialias = cgi["antialias"].read=="on" if cgi.has_key?("antialias")

res = 96
res = cgi["res"].read.to_i if cgi.has_key?("res")

res_units = "ppi"
res_units = cgi["res_units"].read if cgi.has_key?("res_units")


$header=<<END
<html>
    <head>
        <title>Composition Profiler - Run</title>
        <link rel="stylesheet" href="#{PATH}profiler.css" type="text/css">
        <link rel="shortcut icon" href="#{PATH}images/favicon.gif">
        <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    </head>
    <body>
        <table width="100%" cellpadding="0" cellspacing="3" border="0" align="center">
        <tr>
        <td width="60%" align="left" valing="bottom"><a href="#{PATH}index.html"><img src="#{PATH}images/cprof.gif" width="167" height="41" border="0" alt="Composition Profiler" hspace="10" vspace="0"></a></td>
        <td align="right" valign="bottom">
<a href="#{PATH}index.html">Home</a> |
Run Profiler | 
<a href="#{PATH}examples.html">Examples</a> |
<a href="#{PATH}help.html">Help</a></td>
        </tr>
END

$body=<<END
        <form name="form" method="post" action="profiler.cgi" enctype="multipart/form-data">

        <tr>
        <td valign="top" align="center">

            <table width="100%" cellpadding="0" cellspacing="3" border="0" align="center">
            <tr>
            <td colspan="2">
            <h5>Query Sample</h5>
            </td>
            </tr>
            <tr>
            <td valign="top">
            <input type="radio" name="query_source" value="B" #{"checked=\"checked\"" if query_source=="B"}> 
            </td>
            <td>
            <textarea name="query_sample" rows="8" cols="58">#{query_sample}</textarea><br>
            Upload query sample file: <input type="file" name="query_file">
            <a href="#{PATH}help.html#sample"><img src="#{PATH}images/info.gif" width="12" height="12" border="0" alt="help"></a><br><br>
            </td>
            </tr>
            <tr>
            <td valign="top">
            <input type="radio" name="query_source" value="D" #{"checked=\"checked\"" if query_source=="D"}>
            </td>
            <td>Dataset: 
            <select name="query_distrib">
                <option value="sprot" #{"selected=\"selected\"" if query_distrib=="sprot"}>SwissProt 51</option>
                <option value="pdbs25" #{"selected=\"selected\"" if query_distrib=="pdbs25"}>PDB Select 25</option>
                <option value="surface" #{"selected=\"selected\"" if query_distrib=="surface"}>Surface residues</option>
                <option value="disprot" #{"selected=\"selected\"" if query_distrib=="disprot"}>DisProt 3.4</option>
            </select><a href="#{PATH}help.html#distribution"><img src="#{PATH}images/info.gif" width="12" height="12" border="0" alt="help"></a>
            </td>
            </tr>
            <tr>
            <td colspan="2">
            <h6>Background Sample</h6>
            </td>
            </tr>
            <td valign="top">
            <input type="radio" name="back_source" value="B" #{"checked=\"checked\"" if back_source=="B"}> 
            </td>
            <td>
            <textarea name="back_sample" rows="8" cols="58">#{back_sample}</textarea><br>
            Upload background sample file: <input type="file" name="back_file">
            <a href="#{PATH}help.html#sample"><img src="#{PATH}images/info.gif" width="12" height="12" border="0" alt="help"></a><br><br>
            </td>
            </tr>
            <tr>
            <td valign="top">
            <input type="radio" name="back_source" value="D" #{"checked=\"checked\"" if back_source=="D"}>
            </td>
            <td>Dataset: 
            <select name="back_distrib">
                <option value="sprot" #{"selected=\"selected\"" if back_distrib=="sprot"}>SwissProt 51</option>
                <option value="pdbs25" #{"selected=\"selected\"" if back_distrib=="pdbs25"}>PDB Select 25</option>
                <option value="surface" #{"selected=\"selected\"" if back_distrib=="surface"}>Surface residues</option>
                <option value="disprot" #{"selected=\"selected\"" if back_distrib=="disprot"}>DisProt 3.4</option>
            </select><a href="#{PATH}help.html#distribution"><img src="#{PATH}images/info.gif" width="12" height="12" border="0" alt="help"></a>
            </td>
            </tr>
            </table>

        </td>

        <td valign="top" align="center">
            <table width="100%" cellpadding="0" cellspacing="3" border="0" align="center">
            <tr>
            <td colspan="2">
            <h4>General Options</h4>
            </td>
            </tr>

            <tr>
            <td>&nbsp; Bootstrap iterations: 
            </td>
            <td>            
            <select name="iterations">
                <option value="500">500</option>
                <option value="1000">1,000</option>
                <option value="5000">5,000</option>
                <option value="10000" selected="selected">10,000</option>
                <option value="50000">50,000</option>
                <option value="100000">100,000</option>
            </select>
            <a href="#{PATH}help.html#iterations"><img src="#{PATH}images/info.gif" width="12" height="12" border="0" alt="help"></a>
            </td>
            </tr>

            <tr>
            <td>&nbsp; Significance (&alpha;) value:
            </td>
            <td>            
            <select name="alpha_value">
                <option value="0.005"">0.005</option>
                <option value="0.01">0.01</option>
                <option value="0.05" selected="selected">0.05</option>
                <option value="0.1">0.1</option>
                <option value="0.5">0.5</option>
            </select>
            <a href="#{PATH}help.html#alpha_value"><img src="#{PATH}images/info.gif" width="12" height="12" border="0" alt="help"></a>
            </td>
            </tr>

            <tr>
            <td>&nbsp; Bonferroni correction:
            </td>
            <td>            
            <input type="checkbox" name="bonferroni" value="on">
            <a href="#{PATH}help.html#bonferroni"><img src="#{PATH}images/info.gif" width="12" height="12" border="0" alt="help"></a>
            </td>
            </tr>

            <tr>
            <td colspan="2"><br>
            <h4>Output Options</h4>
            </td>
            </tr>


            <tr>
            <td>&nbsp; Output format: 
            </td>
            <td>            
            <select name="format">
                <option value="GIF">GIF (bitmap)</option>
                <option value="PNG" selected="selected">PNG (bitmap)</option>
                <option value="EPS">EPS (vector)</option>
                <option value="PDF">PDF (vector)</option>
                <option value="TXT">TXT (raw values)</option>
            </select>
            <a href="#{PATH}help.html#format"><img src="#{PATH}images/info.gif" width="12" height="12" border="0" alt="help"></a>
            </td>
            </tr>

            <tr>
            <td>&nbsp; Ordering:
            </td>
            <td>            
            <select name="order">
                <option value="alpha"        #{"selected=\"selected\"" if order=="alpha"}>Alphabetical</option>
                <option value="alpha_n"      #{"selected=\"selected\"" if order=="alpha_n"}>Alpha helix frequency (Nagano)</option>
                <option value="diff"         #{"selected=\"selected\"" if order=="diff"}>By observed differences</option>
                <option value="beta_n"       #{"selected=\"selected\"" if order=="beta_n"}>Beta structure frequency (Nagano)</option>
                <option value="bulkiness_z"  #{"selected=\"selected\"" if order=="bulikness_z"}>Bulkiness (Zimmerman)</option>
                <option value="coil_n"       #{"selected=\"selected\"" if order=="coil_n"}>Coil propensity (Nagano)</option>
                <option value="flex_v"       #{"selected=\"selected\"" if order=="flex_v"}>Flexibility (Vihinen)</option>
                <option value="hydro_e"      #{"selected=\"selected\"" if order=="hydro_e"}>Hydrophobicity (Eisenberg)</option>
                <option value="hydro_kd"     #{"selected=\"selected\"" if order=="hydro_kd"}>Hydrophobicity (Kyte-Doolittle)</option>
                <option value="hydro_fp"     #{"selected=\"selected\"" if order=="hydro_fp"}>Hydrophobicity (Fauchere-Pliska)</option>
                <option value="interface_jt" #{"selected=\"selected\"" if order=="interface_jt"}>Interface propensity (Jones-Thornton)</option>
                <option value="linker_gh"    #{"selected=\"selected\"" if order=="linker_gh"}>Linker propensity (George-Heringa)</option>
                <option value="polarity_z"   #{"selected=\"selected\"" if order=="polarity_z"}>Polarity (Zimmerman)</option>
                <option value="size_d"       #{"selected=\"selected\"" if order=="size_d"}>Size (Dawson)</option>
                <option value="surface_j"    #{"selected=\"selected\"" if order=="surface_j"}>Surface exposure (Janin)</option>
                <option value="solvation_jt" #{"selected=\"selected\"" if order=="solvation_jt"}>Solvation potential (Jones-Thornton)</option>
            </select>
            <a href="#{PATH}help.html#order"><img src="#{PATH}images/info.gif" width="12" height="12" border="0" alt="help"></a>
            </td>
            </tr>

            <tr>
            <td>&nbsp; Output size:
            </td>
            <td>
            <input type="text" name="chart_width" size="6" maxlength="80" value="#{chart_width}"> X
            <input type="text" name="chart_height" size="6" maxlength="80" value="#{chart_height}"> 
            <select name="chart_units">
                <option value="cm">cm</option>
                <option value="inches" selected="selected">inches</option>
                <option value="pixels">pixels</option>
                <option value="points">points</option>
            </select>
            <a href="#{PATH}help.html#size"><img src="#{PATH}images/info.gif" width="12" height="12" border="0" alt="help"></a>
            </td>
            </tr>

            <tr>
            <td>&nbsp; Color scheme:
            </td>
            <td>
            <select name="color">
                <option value="alpha_n"      #{"selected=\"selected\"" if color=="alpha_n"}>Alpha helix frequency (N)</option>
                <option value="amino"        #{"selected=\"selected\"" if color=="amino"}>Amino color scheme</option>
                <option value="aromatics"    #{"selected=\"selected\"" if color=="aromatics"}>Aromatics</option>
                <option value="beta_n"       #{"selected=\"selected\"" if color=="beta_n"}>Beta structure frequency (N)</option>
                <option value="bw"           #{"selected=\"selected\"" if color=="bw"}>Black and white</option>
                <option value="bulkiness_z"  #{"selected=\"selected\"" if color=="bulikness_z"}>Bulkiness (Z)</option>
                <option value="charge"       #{"selected=\"selected\"" if color=="charge"}>Charge</option>
                <option value="coil_n"       #{"selected=\"selected\"" if color=="coil_n"}>Coil propensity (N)</option>
                <option value="disorder_d"   #{"selected=\"selected\"" if color=="disorder_d"}>Disorder propensity (D)</option>
                <option value="flex_v"       #{"selected=\"selected\"" if color=="flex_v"}>Flexibility</option>
                <option value="hydro_e"      #{"selected=\"selected\"" if color=="hydro_e"}>Hydrophobicity (E)</option>
                <option value="hydro_kd"     #{"selected=\"selected\"" if color=="hydro_kd"}>Hydrophobicity (K-D)</option>
                <option value="hydro_fp"     #{"selected=\"selected\"" if color=="hydro_fp"}>Hydrophobicity (F-P)</option>
                <option value="interface_jt" #{"selected=\"selected\"" if color=="interface_jt"}>Interface propensity (J-T)</option>
                <option value="linker_gh"    #{"selected=\"selected\"" if color=="linker_gh"}>Linker propensity (G-H)</option>
                <option value="polarity_z"   #{"selected=\"selected\"" if color=="polarity_z"}>Polarity (Z)</option>
                <option value="shapley"      #{"selected=\"selected\"" if color=="shapley"}>Shapley color scheme</option>
                <option value="size_d"       #{"selected=\"selected\"" if color=="size_d"}>Size (D)</option>
                <option value="surface_j"    #{"selected=\"selected\"" if color=="surface_j"}>Surface exposure (J)</option>
                <option value="solvation_jt" #{"selected=\"selected\"" if color=="solvation_jt"}>Solvation potential (J-T)</option>
                <option value="weblogo"      #{"selected=\"selected\"" if color=="weblogo"}>Weblogo color scheme</option>
            </select>
            <a href="#{PATH}help.html#color"><img src="#{PATH}images/info.gif" width="12" height="12" border="0" alt="help"></a>
            </td>
            </tr>

            <tr>
            <td>&nbsp; Antialias bitmaps:
            </td>
            <td>
            <input type="checkbox" name="antialias" value="on" checked="checked">
            <a href="#{PATH}help.html#antialias"><img src="#{PATH}images/info.gif" width="12" height="12" border="0" alt="help"></a>
            </td>
            </tr>

            <tr>
            <td>&nbsp; Y-axis label:
            </td>
            <td>
            <input type="text" name="yaxis" size="30" maxlength="100" value="#{yaxis}">
            <a href="#{PATH}help.html#yaxis"><img src="#{PATH}images/info.gif" width="12" height="12" border="0" alt="help"></a>
            </td>
            </tr>

            <tr>
            <td>&nbsp; Bitmap resolution:
            </td>
            <td>
            <input type="text" name="res" value="96" size="4" maxlength="8">
            <select name="res_units">
                <option value="ppc">pixels/cm</option>
                <option selected="selected" value="ppi">pixels/inch (dpi)</option>
                <option value="ppp">pixels/point</option>
            </select>
            <a href="#{PATH}help.html#resolution"><img src="#{PATH}images/info.gif" width="12" height="12" border="0" alt="help"></a>
            </td>
            </tr>

            <tr>
            <td colspan="2">
                <hr noshade size="1">
                <center>
                <input type="hidden" name="command" value="create">
                <input type="submit" name="submit"  value="Discover">
                <input type="submit" name="submit"  value="Draw Profile">
                <input type="submit" name="submit"  value="Relative Entropy">
                <input type="reset"  name="reset"   value="Reset">
                </center>
            </td>
            </tr>
            </table>
        </form>
        </table>

        </td>
        </tr>
        </table>

        <table width="100%">
        <tr>
        <td>
        <hr noshade size="3">
        </td>
        </tr>

END


$footer=<<END
        </table>
    </body>
</html>
END


#
# Utility function for diplaying error messages.
#
def print_error(message)
    print "Content-type: text/html\n\n"
    print $header
    print "<tr><td colspan=\"2\" align=\"center\"><br><br><br><font color=\"red\" size=\"+1\">Error: #{message}</font></td></tr>\n"  
    print $footer
    exit
end

#
# Utility function for determining and displaying significance.
#
def print_significance(property, pattern, alpha_value)
    query_pos = 0
    back_pos = 0

    for i in 0...pattern.length
        query_pos += $query_counts[pattern[i,1]]
        back_pos  += $back_counts[pattern[i,1]]
    end

    result = `./pvalue #{query_pos} #{$query_total} #{back_pos} #{$back_total}`.to_f

    print "<tr><td width=\"200\">#{property}</td><td width=\"120\">"

    if result <= alpha_value
        if 1.0*query_pos/$query_total > 1.0*back_pos/$back_total
            print "<img src=\"#{PATH}images/up.gif\" width=\"10\" height=\"14\" hspace=\"2\"><font color=\"green\">Enriched."
        elsif 1.0*query_pos/$query_total < 1.0*back_pos/$back_total
            print "<img src=\"#{PATH}images/down.gif\" width=\"10\" height=\"14\" hspace=\"2\"><font color=\"red\">Depleted."
        else
            print "<img src=\"#{PATH}images/dot.gif\" width=\"10\" height=\"14\" hspace=\"2\">No difference."
        end
        printf("</font></td><td width=\"200\">P-value=%6f (&le;%6f)</td></tr>\n", result, alpha_value)
    else
        print "<img src=\"#{PATH}images/dot.gif\" width=\"10\" height=\"14\" hspace=\"2\">Not significant."
        printf("</td><td width=\"200\">P-value=%6f (>%6f)</td></tr>\n", result, alpha_value)
    end
end



#
# Main code starts here.
#

case command
when "create"
    #
    # BASIC ERROR CHECKING + COMMON OPERATIONS
    #
    query = nil
    if "B"==query_source
        if query_sample.empty?
            if query_file.empty?
                print_error("Query sample missing.")
            else
                query = query_file.upcase.delete(" \t") 
            end
        else
            query = query_sample.upcase.delete(" \t")
        end
    end

    background = nil
    if "B"==back_source
        if back_sample.empty?
            if back_file.empty?
                print_error("Background sample missing.")
            else
                background = back_file.upcase.delete(" \t") 
            end
        else
            background = back_sample.upcase.delete(" \t")
        end
    end

    if "Relative Entropy"==submit
        print "Content-type: text/html\n\n"
        print $header
        print "<tr><td><br><blockquote><table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">"

        if iterations>1000
            i = 1000
        else
            i = iterations
        end


        if "B"==query_source
            fasta_1 = "#{temp}#{rand.to_s[2,15].to_s}.fa"
            f = File.open(fasta_1, "w")
            f.print query
            f.close
        else
            fasta_1 = datasets

            case query_distrib 
            when "sprot"
                fasta_1 += "sprot51_5k.fa"
            when "pdbs25"
                fasta_1 += "pdb_s25.fa"
            when "surface"
                fasta_1 += "monomers.fa"
            when "disprot"
                fasta_1 += "disprot_3.4.fa"
            end 
        end

        if "B"==back_source
            fasta_2 = "#{temp}#{rand.to_s[2,15].to_s}.fa"
            f = File.open(fasta_2, "w")
            f.print background
            f.close
        else
            fasta_2 = datasets

            case back_distrib 
            when "sprot"
                fasta_2 += "sprot51_5k.fa"
            when "pdbs25"
                fasta_2 += "pdb_s25.fa"
            when "surface"
                fasta_2 += "monomers.fa"
            when "disprot"
                fasta_2 += "disprot_3.4.fa"
            end 
        end

        result = `./rentropy #{fasta_1} #{fasta_2} #{i}`
        r = result.split("\n")

        print "Relative entropy: #{r[0]}<br>p-value: #{r[1]}<br><br>"

        print "Due to limited computational resources, the web version of Composition Profiler does not allow more than 1,000 iterations for relative entropy p-values calculations. If you need precision better than 10<sup>-3</sup>, please download the command line version.<br><br>" if i<iterations

        print "</table></blockquote><br></td><td></td></tr><tr><td colspan=\"2\"><hr noshade size=\"3\"></td></tr>"
        print $footer
    end

    #
    # QUERY
    #
    if "D"==query_source
        $query_counts = AminoAcid::COUNTS[query_distrib] 
    end

    if "B"==query_source
        $query_counts = Hash.new
        AminoAcid::ALL_1.each  { |aa| $query_counts[aa]=0 }

        f = Fasta.read_stream(query)

        print_error("Query sample not in FastA format.") if (0==f.length)

        f.each do |s|
            for i in 0...s.sequence.length
                begin 
                    $query_counts[s.sequence[i,1]] += 1
                rescue
                    # Unknown amino acid symbol
                end
            end
        end 
    end

    $query_total = 0
    AminoAcid::ALL_1.each  { |aa| $query_total += $query_counts[aa] }

    #
    # BACKGROUND
    #
    if "D"==back_source
        $back_counts = AminoAcid::COUNTS[back_distrib] 
    end

    if "B"==back_source
        $back_counts = Hash.new
        AminoAcid::ALL_1.each  { |aa| $back_counts[aa]=0 }

        f = Fasta.read_stream(background)

        print_error("Background sample not in FastA format.") if (0==f.length)

        f.each do |s|
            for i in 0...s.sequence.length
                begin 
                    $back_counts[s.sequence[i,1]] += 1
                rescue
                    # Unknown amino acid symbol
                end
            end
        end 
    end

    $back_total = 0
    AminoAcid::ALL_1.each  { |aa| $back_total += $back_counts[aa] }

    if "Discover"==submit
        alpha_value /= 40 if bonferroni

        print "Content-type: text/html\n\n"
        print $header
        print "<tr><td><br><blockquote><table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">"

        #
        # Individual amino-acids
        #
        AminoAcid::ALL_1.each do |aa|
            print_significance(AminoAcid::CODE[aa], aa, alpha_value)
        end

        print "</table><br><br>"
        print "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">"
 
        #
        # Amino-acids grouped by properties
        #
        AminoAcid::SPLIT_ORDER.each do |prop|
            print_significance(AminoAcid::SPLIT_NAME[prop], AminoAcid::SPLIT[prop], alpha_value)
        end
 
        print "</table></blockquote><br></td><td></td></tr><tr><td colspan=\"2\"><hr noshade size=\"3\"></td></tr>"
        print $footer
    end

    if "Draw Profile"==submit
        alpha_value /= 20 if bonferroni

        mean_q = Array.new
        std_q  = Array.new

        if "B"==query_source
            output = "#{rand.to_s[2,15].to_s}.fa"
            f = File.open("#{temp}#{output}", "w")
            f.print query
            f.close

            result = `./frequency #{temp}#{output} #{iterations}`

            result.each_line do |line|
                fields = line.split
                mean_q << fields[0].strip.to_f
                std_q  << fields[1].strip.to_f
            end
        end

        if "D"==query_source
            AminoAcid::ALL_1.each do |aa|
                mean_q << AminoAcid::COMPOSITION[query_distrib][aa]
                std_q  << AminoAcid::STDEV[query_distrib][aa]
            end
        end

        mean_b = Array.new
        std_b  = Array.new

        if "B"==back_source
            output = "#{rand.to_s[2,15].to_s}.fa"
            f = File.open("#{temp}#{output}", "w")
            f.print background
            f.close

            result = `./frequency #{temp}#{output} #{iterations}`
            result.each_line do |line|
                fields = line.split
                mean_b << fields[0].strip.to_f
                std_b  << fields[1].strip.to_f
            end
        end

        if "D"==back_source
            AminoAcid::ALL_1.each do |aa|
                mean_b << AminoAcid::COMPOSITION[back_distrib][aa]
                std_b  << AminoAcid::STDEV[back_distrib][aa]
            end
        end

        mean  = Hash.new
        stdev = Hash.new

        for i in 0...20 do
            b = (mean_q[i] - mean_b[i]) / mean_b[i]
            e = ((mean_q[i] + std_q[i] - mean_b[i] - std_b[i]) / (mean_b[i] + std_b[i]) - b).abs
            e *= -1 if b < 0

            aa = AminoAcid::ALL_1[i]
            mean[aa] = b
            stdev[aa] = e
        end

        options = {
            'HEIGHT'       => chart_height.to_f,
            'WIDTH'        => chart_width.to_f,
            'UNITS'        => chart_units,
            'COLOR_SCHEME' => color,
            'RES'          => res.to_f,
            'RES_UNITS'    => res_units,
            'FORMAT'       => format,
            'ANTIALIAS'    => antialias,
            'YAXIS'        => yaxis,
        }

        if options['UNITS']=="inches"
            options['HEIGHT'] *= 2.54
            options['WIDTH']  *= 2.54
        elsif options['UNITS']=="pixels"
            options['HEIGHT'] *= 2.54 / options['RES']
            options['WIDTH']  *= 2.54 / options['RES']
        elsif options['UNITS']=="points"
            options['HEIGHT'] *= 2.54 / 72
            options['WIDTH']  *= 2.54 /72
        end

        options['RES']       = 96    if options['RES'] == nil
        options['RES_UNITS'] = 'ppi' if options['RES_UNITS'] == nil

        options['HEIGHT'] = (options['HEIGHT'] * (72 / 2.54)).round
        options['WIDTH']  = (options['WIDTH']  * (72 / 2.54)).round

        sorting = Array.new
        bars    = Array.new
        errors  = Array.new

        if "diff"==order
            unsorted = Array.new
            for i in 0...20
                pair = Array.new
                pair << mean[AminoAcid::ALL_1[i]] << AminoAcid::ALL_1[i]
                unsorted << pair
            end 

            unsorted = unsorted.sort  { |a,b| a[0] <=> b[0] }

            for i in 0...20
                sorting << unsorted[i][1]
                bars    << mean[sorting.last]
                errors  << stdev[sorting.last]
            end
        else
            for i in 0...20
                sorting << AminoAcid::ORDER[order][i,1]
                bars    << mean[sorting.last]
                errors  << stdev[sorting.last]
            end
        end

        output = "#{rand.to_s[2,15].to_s}.#{format.downcase}"

        DrawChart.create(sorting, bars, errors, options, output, temp)


$stderr.print "4"


        case format
        when "PNG", "GIF"
            print "Content-type: text/html\n\n"
            print $header
            print "<tr><td><br><blockquote><img src=\"../cache/#{output}\"><br><br>"

            print "Legend can be found on the <a href=\"#{PATH}help.html#color\">help</a> page.<br><br>"

            print "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">"

            for i in 0...20
                aa = sorting[i]
                print_significance(aa, aa, alpha_value)
            end

            print "</table></blockquote><br></td><td></td></tr><tr><td colspan=\"2\"><hr noshade size=\"3\"></td></tr>"
            print $footer

        when "EPS", "PDF"
            print "Content-type: text/html\n\n"
            print $header
            print "<tr><td><br><blockquote><a href=\"../cache/#{output}\">#{format}</a> file is available for download.<br><br>"
            print "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">"

            for i in 0...20
                aa = sorting[i]
                print_significance(aa, aa, alpha_value)
            end

            print "</table></blockquote><br></td><td></td></tr><tr><td colspan=\"2\"><hr noshade size=\"3\"></td></tr>"
            print $footer

        when "TXT"
            print "Content-type: text/html\n\n"
            print "<html><body><pre>"
           
            for i in 0...20
                aa = sorting[i]
                printf("%s\t%6f\t%6f\n", aa, mean[aa], stdev[aa])
            end
            print "</pre></body></html>"
        end

    end
else
    print "Content-type: text/html\n\n"
    print $header
    print $body
    print $footer

end
